from typing import List, Dict

def menu(choix : List[str]) -> int:
	""" Propose un menu et renvoie le choix de l'utilisateur
	@param choix les choix disponibles
	@return un nombre qui peut être en dehors de la plage de choix
	"""
	print("")
	for i in range(len(choix)) :
		print(i,":",choix[i])
	reponse : int = int (input("votre choix : "))
	print("")
	return reponse

def ajouter(classe : List[Dict], prenom : str, age : int):
	""" Ajoute un·e étudiant·e à la classe
	@param classe la collection des membres de la classe, en entrée-sortie
	@param prenom le prenom de l'étudiant·e à ajouter
	@param age l'âge de l'étudiant·e à ajouter
	"""
	classe.append( { "prenom" : prenom, "age" : age })

def supprimer(classe : List[Dict], prenom : str):
	""" Supprime un·e étudiant·e à la classe
	@param classe la collection des membres de la classe, en entrée-sortie
	@param prenom le prenom de l'étudiant·e à supprimer
	"""
	i : int = 0
	found : bool = False
	while (i < len(classe) and not(found)):
		if (classe[i]["prenom"] == prenom):
			classe.remove(classe[i])
			found = True
		i = i + 1

def afficher(classe : List[Dict]):
	""" Affiche la liste des étudiant·e·s de la classe
	@param classe la collection des membres de la classe, en entrée
	"""
	print("Liste des étudiant·e·s :")
	for i in range(len(classe)):
		eleve : Dict = classe[i]
		print(eleve["prenom"], ":", eleve["age"], "ans")

def moyenne(classe : List[Dict]) -> float:
	""" Calcule la moyenne d'âge des étudiant·e·s de la classe
	@param classe la collection des membres de la classe, en entrée
	@return la moyenne d'âge ou 0 si la classe est vide
	>>> moyenne([{ "prenom": "Hina", "age": 20 }, { "prenom": "Jean", "age": 22 }])
	21.0
	>>> moyenne([])
	0
	"""
	somme : int = 0
	for i in range(len(classe)):
		somme = somme + classe[i]["age"]
	return somme / len(classe) if len(classe) != 0 else 0

if __name__ == "__main__":
	import doctest; doctest.testmod()
	sio : List[Dict] = [] #un tableau de dictionnaires
									#dont les clés sont des chaînes et les valeurs de type variable
	choix : int = -1
	while (choix != 0):
		if (choix == 1):
			p : str = input("prénom : ")
			a : int = int(input("age : "))
			ajouter(sio, p, a)
		elif (choix == 2):
			p : str = input("prénom : ")
			supprimer(sio, p)
		elif (choix == 3):
			afficher(sio)
		elif (choix == 4):
			moy : float = moyenne(sio)
			print("moyenne d'âge : " + str(moy))
		#si l'utilisateur saisit une valeur invalide, on ne fait rien de particulier
		choix= menu(["quitter", "ajouter","supprimer","afficher","moyenne"])
